*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Chlorethoxyfos                               *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";
libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data Chlorethoxyfos;
     set epa.Chlorethoxyfos;
run;
proc sort data=Chlorethoxyfos;
     by id;
run;

/*
ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Chlorethoxyfos - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Chlorethoxyfos);
ods rtf close;
*/

*==> Human vs. rat;

title2 "final model 2: a model with same random effects between species";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=Chlorethoxyfos tech= newrap lis=3 maxiter=100000 /* method=firo */ ;
      PARMS ha=0.1 0.5 0.9 1.4 hb1=0.1 to 0.9 by 0.1 
			ra=0.1 0.5 0.9 1.4	rb=0.1 0.5 0.9 1.4
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=0.1 0.2 0.3 / best=50;
			hb=hb1*10;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-8 + H_I__M + rrb*Rat*1e-8 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
	  RANDOM  ua ub ~ normal([0, 0],	[gha, 
												 		 ghab,ghb]) SUBJECT=ID out=RandID_HR; 

	  ESTIMATE "human/rat" (ha/(hb1*10))/(ra/rb);
	  ESTIMATE 'human ki' (ha/(hb1*10));
      ESTIMATE 'rat ki' (ra/rb);
	  estimate 'hb' hb1*10;
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
  	  predict pred2 out=Resid_HR;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Chlorethoxyfos human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=Chlorethoxyfos, model=2)
ods rtf close;

*==> Adult vs. Infant;


title "CEB final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=Chlorethoxyfos(where=(Human=1)) tech=nrridg lis=3 method=firo maxiter=100000;
      PARMS ada=0.1 0.5 0.9 1.4	adB=0.1 0.5 0.9 1.4
			ia=0.1 0.5 0.9 1.4 iB=0.1 0.5 0.9 1.4
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2/100;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-6 + H_I__M*adult + rib*1e-6*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2/100;
	  id pred2;
      predict pred2 out=Resid_AI;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Chlorethoxyfos Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=Chlorethoxyfos, model=2);
ods rtf close;

*===> Male vs. Female;



title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=Chlorethoxyfos(where=(Human=1)) method=firo /* itdetails */ tech=newrap lis=3 maxiter=100000;
      PARMS ma=0.1 0.5 0.9 1.4 mb= 0.1 0.5 0.9 1.4
			fa=0.1 0.5 0.9 1.4 fb=0.1 0.5 0.9 1.4
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2/100;
			rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-7 + H_I__M*male + rfb*female*1e-7 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2/100;
	  id pred2;
		predict pred2 out=Resid_MF;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Chlorethoxyfos Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=Chlorethoxyfos, model=2);
ods rtf close;


*===> Caucasian vs. Other Races;



title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=Chlorethoxyfos(where=(Human=1)) method=firo /* itdetails */ tech=newrap lis=3 maxiter=10000 ;
      PARMS ca1=0.1 0.5 0.9	cB=0.1 0.5 0.9
			ora1=0.1 0.5 0.9 orB=0.1 0.5 0.9
			gc1=0.1 0.5 0.9 gc12=0.1 0.5 0.9 gc2=0.1 0.5 0.9 
			S2E=0.1 0.5 0.9 / best= 50;
			gca=gc1*gc1;
			gcab=gc1*gc12;
			gcb=gc12*gc12+gc2*gc2/100;
			ca=ca1*10;
			ora=ora1*10;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-7 + H_I__M*caucasian + rorb*otherrace*1e-7 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
   RANDOM  uha uhb ~ normal([0, 0],   [gca, 
														gcab, gcb]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca1*10/cb)/(ora1*10/orb);
	  ESTIMATE 'Caucasain ki' (ca1*10/cb);
      ESTIMATE 'Other Race ki' (ora1*10/orb);
	  estimate 'ca' ca1*10;
	  estimate 'ora' ora1*10;
	  estimate "gca" gc1*gc1;
	  estimate "gcab" gc1*gc12;
	  estimate "gcb" gc12*gc12+gc2*gc2/100;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Chlorethoxyfos Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=Chlorethoxyfos, model=2);
ods rtf close;

%resids
